model Ex4_3 
import Modelica.Constants.*;
parameter Real L(unit="m")=1"length"; 
parameter Real e=0.8"Emissivity";  
parameter Real sigma(unit="W/m^2.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit="K")=423"Temperature of grey body"; 
parameter Real T2(unit="K")=300"Temperature of surrounding"; 
parameter Real Do(unit="m")=60/1000"Diameter of pipe";  
Real A(unit="sq.m")"outer surface area per meter length of pipe";
Real Qr(unit="W/m")"Heat loss by radiation";
equation
A=pi*Do*L;  
Qr=e*sigma*A*(T1^4-T2^4);
// Ans Varies slightly due to approximation in book   
end Ex4_3;
