model Ex4_6
import Modelica.Constants.*;
parameter Real sigma(unit="W/m^2.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e1=0.79"Emissvity for steel";
parameter Real e2=0.93"Emissvity for brick";
parameter Real T1(unit="K")=500"Temperature of steel tube" ; 
parameter Real T2(unit="K")=300"Temperature of square brick" ;
parameter Real Do(unit="m")=70/1000"Diameter of pipe"; 
parameter Real L(unit="m")=3"length"; 
parameter Real W(unit="m")=0.3"Length of  conduit";   
Real A1(unit="sq.m.")"Area of inner tube";
Real A2(unit="sq.m.")"Area of outer tube";
Real Q(unit="W")"heat loss by  radiation";
equation
A1=pi*Do*L;  
A2=4*(L*W);  
Q=sigma*A1*(T1^4-T2^4)/(1/e1+((A1/A2)*(1/e2-1)));
//Ans varies slightyly due to approximation in book.    
end Ex4_6;
