model Ex5_14
import Modelica.Constants.*;
parameter Real Cpc(unit = "kJ/(kg.K)")=1.986"Heat capacity of crude oil  ";
parameter Real mu1(unit = "N.s/sq m")=2.9*10^(-3)"Viscocity of oil";
parameter Real k1(unit = "W/m.K")=0.136"Thermal conductivity of oil";
parameter Real rho1(unit = "kg/m^3")=824"Density";
//Properties of bottom product:
parameter Real Cp2(unit = "kJ/kg.K")=2.202"Heat capacity";
parameter Real rho2(unit = "kg/m^3")=867"Density";
parameter Real mu2(unit = "N.s/sq m")=5.2*10^(-3)"Viscocity";
parameter Real k2(unit = "W/sq m.K")=0.119"Thermal conductivity";
parameter Real mc_dot(unit = "kg/h")=135000" crude oil flow rate" ;
parameter Real m_dot(unit = "kg/h")=106000"Bottom product flow rate ";
parameter Real t1(unit = "K")=295"Inlet temperature of crude oil";
parameter Real t2(unit = "K")=330"Outlet temperature of crude oil";
parameter Real T1(unit = "K")=420"Inlet temperature of bottom product ";
parameter Real T2(unit = "K")=380"Outlet temperature of bottom product ";
parameter Real Pt(unit = "m")=25/1000"Tube Pitch";
parameter Real B(unit = "m")=0.23 "Baffle spacing";
parameter Real Do(unit = "m")=0.019"[m]Outside diameter for square pitch ";
parameter Real id(unit = "m")=0.6"ID of tube";
parameter Real n=324"No. of tubes";
parameter Real n_p=324/2"No.of tubes per pass";
parameter Real t(unit = "m")=2.1/1000"Thickness ";
parameter Real Npr2=42.35"Prandtl number";
parameter Real L(unit = "m")=4.88 "Length of tube ";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Q(unit = "W")"Rate of heat transfer ";
Real c_dash(unit = "m")"Clearance ";
Real as(unit = "sq m")" Cross flow area of shell ";
Real Gs(unit = "kg/sq m.s")"Shell side mass velocity ";
Real De(unit = "m")"equivalent dimater in shell";
Real Nre"Reynold's number";
Real Npr"Prandtl number";
Real muw(unit="N.s/sq m")"Viscocity of water";
Real Nnu"Nusselt no.";
Real ho(unit = "W/sq m.K")"Outside heat tranbsfer coefficient ";
Real Di(unit = "m")"I.d of tube ";
Real A(unit = "sq m")"Area]";
Real A_p(unit = "sq m")"Total area for flow per pass ";
Real G(unit = "kg/sq m.s")"Mass velocity through tube ";
Real Nre2"Reynold's number";
Real Nnu2"Nusselt no.";
Real hi(unit = "W/sq m.K")"Inside heat transfer cosfficient";
Real hio(unit = "W/sq m.K")"Inside heat transfer cosfficient referred to outside dia ";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Ao(unit = "sq m")"Area";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real Rd(unit="m^2.K/W")"dirt factor";
equation
dT1=T1-t2;                
dT2=T2-t1;                
dTlm=(dT1-dT2)/log(dT1/dT2);         
Q=mc_dot*Cpc*(t2-t1)*1000/3600;                
//Shell side calculations:
c_dash=Pt-Do;                        
as=id*c_dash*B/Pt;                     
//there is a Calculaiton mistake in as
Gs=(m_dot/as)/3600;                           
De=4*(Pt^2-(pi/4)*Do^2)/(pi*Do);     
Nre=De*Gs/mu2;                         
Npr=Cp2*1000*mu2/k2;                        
muw=mu2;                             
Nnu=0.36*(Nre^0.55)*Npr^(1.0/3.0)*(mu2/muw)^(0.14);      
ho=Nnu*k2/De;                       
//Tube side heat transfer coefficient:
Di=Do-2*t;                 
A=(pi/4)*(Di^2);        
A_p=n_p*A;              
G=(mc_dot/A_p)/3600;                        
Nre2=Di*G/mu1;            
Nnu2=0.023*(Nre2^0.8)*(Npr2^0.4);       
hi=Nnu2*k1/Di;                        
hio=hi*Di/Do;                        
Uo=1/(1/ho+1/hio);                 
Uc=Uo;
Ao=n*pi*Do*L;                       
Ud=Q/(Ao*dTlm);                      
Rd=(Uc-Ud)/(Uc*Ud);                  
end Ex5_14;
