package Ex5_15
  model Ex5_15_a
    parameter Real Cp(unit = "kJ/kg.K") = 4 * 10 ^ 3 "Specific heat capacity";
    parameter Real t1(unit = "K") = 295 "Inlet Temperature of liquid";
    parameter Real t2(unit = "K") = 375 "Outlet Temperature of liquid";
    parameter Real sp = 1.1 "Specific gravity of liquid";
    parameter Real v1(unit = "m^3/s") = 1.75 * 10 ^ (-4) "Flow of liquid ";
    parameter Real T(unit = "K") = 395 "Inlet Temperature of steam";
    parameter Real v2(unit = "m^3/s") = 3.25 * 10 ^ (-4) "Flowrate of liquid";
    Real rho(unit = "kg/(m^3") "Density of liquid";
    Real m_dot(unit = "kg/s") "Mass flowrate";
    Real Q(unit = "W") "Rate of heat transfer";
    Real dT1(unit = "K") "Temperature gradient ";
    Real dT2(unit = "K") "Temperature gradient ";
    Real dTlm(unit = "K") "Log mean temperature differnce";
    Real U1A(unit = "W/K") "Overall heat transfer coefficient";
  equation
//CASE I:
    rho = sp * 1000;
    m_dot = v1 * rho;
    Q = m_dot * Cp * (t2 - t1);
    dT1 = T - t1;
    dT2 = T - t2;
    dTlm = (dT1 - dT2) / log(dT1 / dT2);
    U1A = Q / dTlm;
  end Ex5_15_a;




  model Ex5_15_b
  parameter Real Cp(unit = "kJ/kg.K") = 4 * 10 ^ 3 "Specific heat capacity";         
  parameter Real t1(unit = "K") = 295 "Inlet Temperature of liquid";             
  parameter Real sp = 1.1 "Specific gravity of liquid"; 
  parameter Real T(unit = "K") = 395 "Inlet Temperature of steam";             
  parameter Real v2(unit = "m^3/s") = 3.25 * 10 ^ (-4) "Flowrate of liquid";
  parameter Real T2(unit = "K")=370"Outlet Temperature of liquid";                          
  parameter Real U1A(unit = "W/K")=1239"Overall heat transfer coefficient";            
  Real rho(unit = "kg/(m^3") "Density of liquid";
  Real m_dot(unit = "kg/s") "Mass flowrate";
  Real Q(unit = "W") "Rate of heat transfer";
  Real dT1(unit = "K") "Temperature gradient ";
  Real dT2(unit = "K") "Temperature gradient ";
  Real dTlm(unit = "K") "Log mean temperature differnce";
  Real U2A(unit = "W/K") "Overall heat transfer coefficient";
  Real C"constant";
  Real U1(unit = "W/sq m K") "Overall heat transfer coefficient";
  Real U2(unit = "W/sq m K") "Overall heat transfer coefficient";
  Real A(unit = "sq m")"Area";
  equation
  //CASE-II
  rho=sp*1000;
  m_dot=v2*rho;          
  Q=m_dot*Cp*(T2-t1);                
  dT1=T-t1;                          
  dT2=T-T2;                         
  dTlm=(dT1-dT2)/log(dT1/dT2);       
  U2A=Q/dTlm;                      
  U2=U2A/U1A*U1;                
  5.508*(3400+9.87*10^(-4)*C)=5.371*(3400+1.62*10^(-3)*C);
  U1=(3400*C*(1.75*10^(-4))^0.8)/(3400+C*(1.75*10^(-4))^0.8);                
  A=U1A/U1;       
  //Value of C is wrongly Calculated.        
  end Ex5_15_b;























end Ex5_15;
