model Ex5_16
import Modelica.Constants.*;
parameter Real mo_dot(unit = "kg/s")=6*10^(-2)"Mass flow rate of oil ";             
parameter Real Cpo(unit="J/kg.K")=2*10^3"Specific heat of oil ";                       
parameter Real Cpw(unit="J/kg.K")=4.18*10^3"Specific heat of water";                        
parameter Real T1(unit = "K")=420"Inlet temperature of oil";                     
parameter Real T2(unit = "K")=320"Outlet temperature of oil";                     
parameter Real T(unit = "K")=290"Inlet temperature of water";
parameter Real hi(unit = "W/sq m.K")=1.6*1000"oil side heat transfer coefficient";
parameter Real ho(unit = "W/sq m.K")=3.6*1000"water side heat transfer coefficient";
parameter Real D(unit = " m")=0.025"Daimeter";            
Real Q(unit = "W")"Rate of Heat transfer";
Real t2(unit = "K")"Outlet temperature of water";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real U(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real A(unit = "sq m")"Area";
Real L(unit = " m")"length";
equation
Q=mo_dot*Cpo*(T1-T2);        
//Heat given out =Heat gained
t2=Q/(mo_dot*Cpw)+T;         
dT1=T1-t2;                   
dT2=T2-T;                    
dTlm=(dT1-dT2)/log(dT1/dT2); 
U=1/(1/ho+1/hi); 
A=Q/(U*dTlm);       
L=A/(pi*D);     
end Ex5_16;
