model Ex5_18
import Modelica.Constants.*;
parameter Real m_dot(unit = "kg/h")=4500"Benzene condensation rate";
parameter Real lambda(unit = "kJ/kg")=394"Latent heat of condensation of benzene ";
parameter Real Cpw(unit = "kJ/kg.K")=4.18"Heat capacity of water";
parameter Real t1(unit = "K")=295"Inlet Temperature of Water ";
parameter Real t2(unit = "K")=300"Outlet Temperature of Water ";
parameter Real rho(unit="kg/m^3")=1000"Density";                    
parameter Real u(unit = "m/s")=1.05"Velocity";
parameter Real x(unit = "m")=1.6/1000"thickness";
parameter Real Do(unit = "m")=0.025"Od of tube";
parameter Real L(unit = "m")=2.5"Length of tube ";
parameter Real Ts(unit = "K")=353"Condensing temp of benzene ";
parameter Real k(unit = "W/(m.K)")=0.15"Thermal conductivity";
parameter Real rho1(unit = "kg/m^3")=880"Density";
parameter Real mu(unit = "N.s/sq m")=0.35*10^(-3)"Viscocity";
parameter Real g(unit = "m/s^2")=9.81"[m/s^2] Acceleration due to gravity";
parameter Real k1(unit = "W/m.K")=45"Thermal conductivity";
Real Q(unit = "W")"rate of heat transfer";
Real mw_dot(unit = "kg/s")"water flow rate ";
Real V(unit = "m^3/s")"Volumetric flow rate ";
Real A(unit = "sq  m")"Surface area for heat transfer";
Real Di(unit = "m")"ID of tube";
Real A1(unit = "sq m")"Area Of one tube ";
Real n"No. of tubes required";
Real Ao(unit = "sq  m")"Surface area for heat transfer ";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient  ";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real T(unit = "K")"Average temperature";
Real hi(unit = "W/sq m.K")"Inside heat transfer coefficient";
Real hio(unit = "W/sq m.K")"Outside heat transfer coefficient ";
Real Dw(unit = "m")"Log mean diameter";
Real mdot_dash(unit = "kg/s")"Mass flowrate of benzene";
Real hm(unit = "W/sq m.K")" Heat transfer coefficient";
Real ho(unit = "W/sq m.K")"Outside heat transfer coefficient";
Real Uo1(unit = "W/sq m.K")"Overall heat transfer coefficient ";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Rd(unit = "sq.m K/W")"Maximum allowable scale resistance ";
Real M(unit = "kg/s.m");
equation
Q=m_dot*lambda*1000/3600;       
//For water :
mw_dot=Q/(Cpw*1000*(t2-t1));     
V=mw_dot/rho;         
A=V/u;                 
//For tube:
Di=Do-2*x;          
A1=(pi*Di^2)/4;      
n=A/A1;                  
Ao=n*pi*Do*L;      
dT1=Ts-t1;          
dT2=Ts-t2;           
dTlm=(dT1-dT2)/log(dT1/dT2);     
Uo=Q/(Ao*dTlm);          
Ud=Uo;                  
//OVERALL HEAT TRANSFER COEFFCIENT:
//Inside side:
T=(t2+t1)/2;             //[K]
hi=1063*((1+0.00293*T)*u^0.8)/(Di^0.2);       
hio=hi*(Di/Do);                                 
Dw=(Do-Di)/log(Do/Di);                           
//Outside of tube:
mdot_dash=1.25/n;                
M=mdot_dash/(pi*Do);            
hm=(1.47*((4*mdot_dash)/mu)^(-1/3))/(mu^2/(k^3*rho1^2*g))^(1/3);  
ho=hm;                           
Uo1=1/(1/ho+1/hio+(x*Do)/(k1*Dw));          
Uc=Uo1;                              
Rd=(Uc-Ud)/(Uc*Ud);                 
end Ex5_18;
