model Ex5_19
parameter Real mw_dot(unit = "kg/s")=5"Water flow rate  ";
parameter Real Cpw(unit = "kJ/kg.K")=4.18"Heat capacity of water";
parameter Real t1(unit = "K")=303"Inlet temperature of water";
parameter Real t2(unit = "K")=343"Outlet temperature of water";
parameter Real T1(unit = "K")=413"Inlet temperature of oil";
parameter Real T2(unit = "K")=373"Outlet temperature of oil";
parameter Real hi(unit = "W/sq m.K")=1000"oil side heat transfer coefficient";
parameter Real ho(unit = "W/sq m.K")=2500"water side heat transfer coefficient";
parameter Real Rd(unit = "m^2.K/W")=1/(0.714*1000)"Fouling factor";
Real Q(unit = "W")"Rate of Heat transfer";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real U(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real A(unit = "sq m")"Area";
equation
Q=mw_dot*Cpw*(t2-t1)*1000;                
dT1=T1-t2;               
dT2=T2-t1;               
dTlm=dT1;                 
U=1/(1/hi+1/ho+Rd);      
A=Q/(U*dTlm);            
end Ex5_19;
