package Ex5_22
  model Ex5_22_a
    import Modelica.Constants.*;
    parameter Real mh_dot(unit = "kg/s") = 16.67 "Mass flow rate of hot fluid ";
    parameter Real mc_dot(unit = "kg/s") = 20 "Mass flow rate of cold fluid ";
    parameter Real Cph(unit = "J/kg.K") = 3.6 * 1000 "Sp heat of hot fluid ";
    parameter Real Cpc(unit = "J/(kg.K)") = 4.2 * 1000 "Sp heat of cold fluid ";
    parameter Real U(unit = "W/sq m.K") = 400 "Overall heat transfer coefficient ";
    parameter Real A(unit = "sq m") = 100 "Surface area ";
    parameter Real T1(unit = "K") = 973 "Hot fluid inlet temperature ";
    parameter Real t1(unit = "K") = 373 "Cold fluid inlet temperature ";
    Real mCp_h(unit = "J/s.K") "Heat capacity rate For hot fluid ";
    Real mCp_c(unit = "J/s.K") "Heat capacity rate For cold fluid ";
    Real mCp_small(unit = "W/K") "Heat capacity rate";
    Real C "Capacity ratio";
    Real ntu "Number of transfer units";
    Real E "Effectiveness";
    Real T2(unit = "K") "Outlet temperature of hot water";
    Real t2(unit = "K ") "Outlet temperature of cold water";
  equation
    mCp_h = mh_dot * Cph;
    mCp_c = mc_dot * Cpc;
    mCp_small = mCp_h;
    C = mCp_small / mCp_c;
    ntu = U * A / mCp_small;
//Case 1:Countercurrent flow arrangement
    E = (1 - e ^ (-(1 - C) * ntu)) / (1 - C * e ^ (-(1 - C) * ntu));
//W=T1-T2/(T1-t1)  therefore:
    T2 = T1 - E * (T1 - t1);
    t2 = mCp_h * (T1 - T2) / mCp_c + t1;
    //Ans varies dur to approximation in value of E
  end Ex5_22_a;



  model Ex5_22_b
  import Modelica.Constants.*;
  parameter Real mh_dot(unit = "kg/s")=16.67"Mass flow rate of hot fluid ";
  parameter Real mc_dot(unit = "kg/s")=20"Mass flow rate of cold fluid ";
  parameter Real Cph(unit = "J/kg.K")=3.6*1000"Sp heat of hot fluid ";
  parameter Real Cpc(unit = "J/(kg.K)")=4.2*1000"Sp heat of cold fluid ";
  parameter Real U(unit = "W/sq m.K")=400"Overall heat transfer coefficient ";
  parameter Real A(unit = "sq m")=100"Surface area ";
  parameter Real T1(unit = "K")=973"Hot fluid inlet temperature ";
  parameter Real t1(unit = "K")=373"Cold fluid inlet temperature ";
  Real mCp_h(unit = "J/s.K")"Heat capacity rate For hot fluid ";
  Real mCp_c(unit = "J/s.K")"Heat capacity rate For cold fluid ";
  Real mCp_small(unit = "W/K")"Heat capacity rate";
  Real C"Capacity ratio";
  Real ntu"Number of transfer units";
  Real E1"Effectiveness";
  Real T2_1(unit = "K")"Outlet temperature of hot water";
  Real t2_1(unit = "K")"Outlet temperature of cold water";
  equation
  mCp_h=mh_dot*Cph;     
  mCp_c=mc_dot*Cpc;    
  mCp_small=mCp_h;     
  C=mCp_small/mCp_c;             
  ntu=U*A/mCp_small;       
  //Case 2:Parallel flow arrangement
  E1=(1-e^(-(1+C)*ntu))/(1+C);
  //In the textbok here is a calculation mistake,and the value of E is takne as E=0.97
  T2_1=T1-E1*(T1-t1);     
  t2_1=mCp_h*(T1-T2_1)/(mCp_c)+t1;     
  end Ex5_22_b;



end Ex5_22;
