model Ex5_4
import Modelica.Constants.*;
parameter Real mc_dot(unit = "kg/s")=1000/3600"mass flowrate of cold fluid ";
parameter Real mh_dot(unit = "kg/s")=250/3600"mass flowrate of hot fluid";
parameter Real Cpc(unit = "J/(kg.K)")=4187"Specific heat capacity of cold";
parameter Real Cph(unit = "J/(kg.K)")=3350"Specific heat capacity of hot fluid ";
parameter Real U(unit = "W/sq m.K")=1160"Ooverall heat transfer coefficient";
parameter Real A(unit = "sq m")=0.25"Heat transfer surface for exchanger ";
parameter Real T1(unit = "K")=393"Inlet temperature ";
parameter Real t1(unit = "K")=283"Cooling water temperature";
Real w(unit = "W/K")"Heat capacity rate of cold fluid";
Real l(unit = "W/K")"Heat capacity rate of hot fluid";
Real C"Capacity ratio";
Real ntu"Number of transfer units";
Real E"Effectiveness of heat exchanger";
Real T2(unit="K")"Outlet temperature of cold fluid";
Real t2(unit = "K")"Outlet temperature of water";
equation
w=mc_dot*Cpc;        
l=mh_dot*Cph;        
C=mh_dot*Cph/(mc_dot*Cpc);
ntu=U*A/(mh_dot*Cph);    
E=(1-e^(-ntu*(1+C)))/(1+C);     
T2=T1-E*(T1-t1);    
t2=C*(T1-T2)+t1;     
end Ex5_4;
