model Ex6_10
parameter Real Ts(unit = "K")=381.3"saturation Temperature";
parameter Real dT(unit = "K")=56.6"Temperature gradient";
parameter Real U1(unit = "W/sq m.K")=2800"Overall heat transfer coeff in first effect";
parameter Real U2(unit = "W/sq m.K")=2200"Overall heat transfer coeff in first effect";
parameter Real U3(unit = "W/sq m.K")=1100"Overall heat transfer coeff in first effect";
Real dT1(unit = "K")"Temperature gradient  for first effect";
Real dT2(unit = "K")"Temperature gradient  for second effect";
Real dT3(unit = "K")"Temperature gradient  for third effect";
Real T1dash(unit = "K")"Boiling point of solution in first  effect";
Real T2_dash(unit = "K")"Boiling point of solution in second effect";
equation
dT1=dT/(1+(U1/U2)+(U1/U3));  
dT2=dT/(1+(U2/U1)+(U2/U3));  
dT3=dT-(dT1+dT2);             
T1dash=Ts-dT1;
T2_dash=T1dash-dT2;           
end Ex6_10;
