model Ex6_13
parameter Real Cpf(unit = "kJ/kg.K")=4.18"Specific Heat capacity";
parameter Real dT1(unit = "K")=18"Temperature Gradient";
parameter Real dT2(unit = "K")=17"Temperature Gradient";
parameter Real dT3(unit = "K")=34"Temperature Gradient";
parameter Real mf_dot(unit = "kg/s")=4"Feed flow.";
parameter Real Ts(unit = "K")=394"Saturation temperature ";
parameter Real bp(unit = "K")=325"Bp of water at 13.172 kPa";
parameter Real lambda_s(unit = "kJ/kg")=2200"latent heat of condensing steam";
parameter Real lambda1(unit = "kJ/kg")=2249"latent heat of vaporization of liquor";
parameter Real lambda2(unit = "kJ/kg")=2293"latent heat of vaporization of liquor";
parameter Real lambda3(unit = "kJ/kg")=2377"latent heat of vaporization of liquor";
parameter Real ic=0.1"Initial conc of solids";
parameter Real fc=0.5"Final conc of solids";
parameter Real mv2_dot(unit = "kg/s")=3.2795/3.079"[kg/s]";
parameter Real U1(unit = "kW/sq m.K")=3.10"Overall Heat transfer coefficient";
parameter Real U2(unit = "kW/sq m.K")=2"Overall Heat transfer coefficient";
parameter Real U3(unit = "kW/sq m.K")=1.10"Overall Heat transfer coefficient";
Real dT(unit = "K")"Temperature Gradient";
Real T1(unit = "K")"Temperature Gradient";
Real lambda_v1(unit = "kJ/kg")"latent heat of vaporization of liquior ";
Real T2(unit = "K")"Tempearture";
Real lambda_v2(unit = "kJ/kg")"latent heat of vaporization of liquior in second effect ";
Real T3(unit = "K")"Tempearture";
Real lambda_v3(unit = "kJ/kg")"latent heat of vaporization of liquior in sThird effect ";
Real m3dot_dash(unit = "kg/s")"Mass flow rate of thick liquor ";
Real mv_dot(unit = "kg/s")"Total evaporation ";
Real mv1_dot(unit = "kg/h")"mass flwrate of vapour";
Real mv3_dot(unit = "kg/s")"mass flwrate of vapour";
Real ms_dot(unit = "kg/h")"mass flowarte of steam";
Real eco "Steam economy";
Real A1(unit = "sq m")"Area";
Real A2(unit = "sq m")"Area";
Real A3(unit = "sq m")"Area";
equation
dT=Ts-bp;        
T1=Ts-dT1;           
lambda_v1=lambda1;       
T2=T1-dT2;          
lambda_v2=lambda2;     
T3=T2-dT3;           
lambda_v3=lambda3;      
m3dot_dash=(ic/fc)*mf_dot;      
mv_dot=mf_dot-m3dot_dash;        
mv1_dot=1.053*mv2_dot-0.1305;     
mv3_dot=1.026*mv2_dot+0.051;     
ms_dot=(mf_dot*Cpf*(T1-294)+mv1_dot*lambda_v1)/lambda_s;     
eco=mv_dot/ms_dot;           
A1=ms_dot*lambda_s/(U1*dT1);        
A2=mv1_dot*lambda_v1/(U2*dT2);       
A3=mv2_dot*lambda_v2/(U3*dT3);        
//A2 calculation done wrong in book
end Ex6_13;
