model Ex6_14
parameter Real mf_dot(unit = "kg/h")=1060"Feed flow.";
parameter Real ic=0.04"Initial concentration";
parameter Real fc=0.25"Final concentration";
//Fromsteam table:
parameter Real P1(unit = "kPa.g")=370"Pressure in first effect";
parameter Real T1(unit = "K")=422.6"Temperature in first effect";
parameter Real lambda1(unit = "kJ/kg")=2114.4"latent heat of vaporization of liquor";
parameter Real P2(unit = "kPa.g")=235"Pressure in second effect";
parameter Real T2(unit = "K")=410.5"Temperature in second effect";
parameter Real lambda2(unit = "kJ/kg")=2151.5"latent heat of vaporization of liquor";
parameter Real P3(unit = "kPa.g")=80"Pressure in third effect";
parameter Real T3(unit = "K")=390.2"Temperature in third effect";
parameter Real lambda3(unit = "kJ/kg")=2210.2"latent heat of vaporization of liquor";
parameter Real P4(unit = "kPa.g")=50.660"Pressure in fourth effect";
parameter Real T4(unit = "K")=354.7"Temperature in fourth effect";
parameter Real lambda4(unit = "kJ/kg")=2304.6"latent heat of vaporization of liquor";
parameter Real P(unit = "kPa .g")=700"Pressure of steam";
parameter Real lambda_s(unit = "kJ/kg")=2046.3"Latent heat of steam";
Real m4dot_dash(unit = "kg/h")"Mass flow rate product";
Real mv_dot(unit = "kg/h")"Total evaporation ";
Real m3dot_dash(unit = "kg/h")"Feed to third effect ";
Real m2dot_dash(unit = "kg/h")"Feed to second effect ";
Real m1dot_dash(unit = "kg/h")"Feed to first effect";
Real ms_dot(unit = "kg/h")"mass flowarte of steam";
Real eco"kg evaporation /kg steam";
equation
m4dot_dash=(ic/fc)*mf_dot;       
//Total evaporation
mv_dot=mf_dot-m4dot_dash; 
//FIRST EFFECT
//Material balance:
//mf_dot-m1dot_dash+mv1_dot;
//Enthalpy balance:
//ms_dot*lambda_s=mf_dot*Cpf*(T1-Tf)+mv1_dot*lambda1;
//On Solving above equation,we get:        
ms_dot=1345.3-1.033*m1dot_dash; 
//SECOND EFFECT
//Material balance:
//m1dot_dash=m2dot_dash+mv2_dot;
//Enthalpy balance:
//mv1_dot*lambda1=m1dot_dash*Cp1*(T2-T1)+mv2_dot*lambda2;
//On Solving above equation,we get:                           
m1dot_dash=531.38+0.510*m2dot_dash;
//THIRD EFFECT
//Material balance:
//m2dot_dash-m3dot_dash+mv3_dot;
//Enthalpy balance:
//mv2_dot*lambda2=m2dot_dash*Cp2*(T3-T2)+mv3_dot*lambda3;
//On Solving above equation,we get:                              
m1dot_dash=1.99*m2dot_dash-1.027*m3dot_dash; 
//FOURTH EFFECT
//Material balance:
//m3dot_dash=m4dot_dash+mv4_dot;
//Enthalpy balance:
//mv3_dot*lambda3=m3dot_dash*Cp3*(T4-T3)+mv4_dot*lambda4;
//On Solving above equation,we get:      
m2dot_dash=1.98*m3dot_dash-176.84;             
eco=mv_dot/ms_dot;          
end Ex6_14;
