package Ex6_4
  model Ex6_4_a
    parameter Real Cpf(unit = "kJ/(kg.K)") = 3.98 "Specific heat of feed ";
    parameter Real lambda_s(unit = "kJ/kg") = 2202 "Latent heat of conds of heat at 0.2MPa";
    parameter Real lambda(unit = "kJ/kg") = 2383 "Latent heat of vaporisation of water aty 323";
    parameter Real ic = 0.1 "Initial concentration of soilds";
    parameter Real fc = 0.5 "Final concentration";
    parameter Real mf_dot(unit = "kg/h") = 30000 "Feed to evaporator";
    parameter Real mv_dot2(unit = "kg/h") = 24000 "Water Evoparated";
    parameter Real Ts(unit = "K") = 393 "Saturation temperature of steam ";
    parameter Real T(unit = "K") = 323 "Boiling point of solution ";
    parameter Real lambda_s2(unit = "kJ/kg") = 2202 "Latent heat of condensation ";
    parameter Real lambda2(unit = "kJ/kg") = 2383 "Latent heat of vaporisation";
    parameter Real Tf(unit = "K") = 293 "Feed temperature";
    parameter Real U(unit = "W/sq m.K") = 2900 "Overall Heat transfer coefficient";
    parameter Real Tf2(unit = "K") = 308 "Feed temperature";
    Real mdash_dot(unit = "kg/h") "Mass flow rate of thick liquor ";
    Real mv_dot(unit = "kg/h") "Water evaporated ";
    Real ms_dot(unit = "kg/h") "Steam consumption ";
    Real eco "Steam economy";
    Real dT(unit = "K") "Temperature gradient";
    Real Q(unit = "W") "Rate of Heat transfer";
    Real A(unit = "sq m") "Heat transfer area ";
  equation
    mdash_dot = ic * mf_dot / fc;
    mv_dot = mf_dot - mdash_dot;
//Case 1: Feed at 293K
//Enthalpy balance over the evaporator:
    ms_dot = (mf_dot * Cpf * (T - Tf) + mv_dot2 * lambda2) / lambda_s2;
    eco = mv_dot2 / ms_dot;
    dT = Ts - T;
    Q = ms_dot * lambda_s * 1000 / 3600;
    A = Q / (U * dT);
  end Ex6_4_a;






  model Ex6_4_b
  parameter Real Cpf(unit = "kJ/(kg.K)")=3.98"Specific heat of feed ";
  parameter Real lambda_s(unit = "kJ/kg")=2202"Latent heat of conds of heat at 0.2MPa" ;
  parameter Real lambda(unit = "kJ/kg")=2383"Latent heat of vaporisation of water aty 323";
  parameter Real ic=0.1"Initial concentration of soilds";
  parameter Real fc=0.5"Final concentration";
  parameter Real mf_dot(unit = "kg/h")=30000"Feed to evaporator";
  parameter Real mv_dot2(unit = "kg/h")=24000"Water Evoparated";
  parameter Real Ts(unit = "K")=393"Saturation temperature of steam ";
  parameter Real T(unit = "K")=323"Boiling point of solution ";
  parameter Real lambda_s2(unit = "kJ/kg")=2202"Latent heat of condensation ";
  parameter Real lambda2(unit = "kJ/kg")=2383"Latent heat of vaporisation";
  parameter Real Tf(unit = "K")=293"Feed temperature";
  parameter Real U(unit = "W/sq m.K")=2900"Overall Heat transfer coefficient";
  parameter Real Tf2(unit = "K")=308"Feed temperature";
  Real mdash_dot(unit = "kg/h")"Mass flow rate of thick liquor ";
  Real mv_dot(unit = "kg/h")"Water evaporated ";
  Real ms_dot2(unit = "kg/h")"Steam consumption";
  Real eco2"Economy of evaporator";
  Real dT(unit = "K") "Temperature gradient";
  Real Q2(unit = "W")"Rate of Heat transfer";
  Real A2(unit = "sq m")"Heat transfer area required [sq m]";
  equation
  mdash_dot=ic* mf_dot/fc;  
  mv_dot=mf_dot-mdash_dot;      
   dT = Ts - T;          
  //Case2: Feed at 308K
  ms_dot2=(mf_dot*Cpf*(T-Tf2)+mv_dot2*lambda)/lambda_s;           
  eco2=mv_dot2/ms_dot2;               
  Q2=ms_dot2*lambda_s*1000/3600;               
  A2=Q2/(U*dT); 
  end Ex6_4_b;











end Ex6_4;
