model Ex2_15
parameter Real A(unit="sq m")=1"Area";  
parameter Real x1(unit="m")=0.1"Thickness of common brick";  
parameter Real x2(unit="m")=0.04"Thickness of gypsum plaster";
parameter Real k1(unit="W/(m.K)")=0.7"Thermal conductivity of common brick";
parameter Real k2(unit="W/(m.K)")=0.48"Thermal conductivity of gypsum plaster";
parameter Real k3(unit="W/(m.K)")=0.065"Thermal conductivity of rockwool isulation";   
Real sigma(unit="K/W")"Thermal Resistance";
Real x3(unit="mm")"thickness of rockwool insulation";
equation
sigma=x1/(k1*A)+x2/(k2*A);
//Q=4.42*dT
//Q=dT/sigma
//with rockwool insulation added,Q_dash=0.75*Q
//Q_dash=dT/sigma+x3/k3*A
//On solving Q and Q_dash we get
x3=((1/(0.75*4.42))-sigma)*k3*1000; 
end Ex2_15;
