model Ex2_18
import Modelica.math.*;
import Modelica.Constants.*;
parameter Real L(unit = "m")=1"length of steam pipe";
parameter Real r1(unit = "m")=0.10"\Outside radius od pipe";
parameter Real ia(unit = "m")=0.025"inner insulaiton ";
parameter Real k1(unit = "W/m.K")=1"Thermal conductivity of A";
parameter Real k2(unit = "W/m.K")=3"Thermal conductivity of B";
parameter Real dT(unit="K")=1"Temperature difference";//Assumed
Real r2(unit="m")"Outer radius of inner insulation";
Real r3(unit="m")"Outer radius of outer insulation";
Real Q1(unit="W/m")"Heat loss";
Real Q2(unit="W/m")"Heat loss";
Real percent(unit="%")"percent reduction in heat loss";
equation
r2=r1+ia;    
r3=r2+ia;    
Q1=dT/(log(r2/r1)/(2*pi*k1*L)+log(r3/r2)/(2*pi*k2*L));   
Q2=dT/(log(r2/r1)/(2*pi*k2*L)+log(r3/r2)/(2*pi*k1*L));     
percent=(Q2-Q1)*100/Q1;   
// Ans varies slightly due to approximation in book.
end Ex2_18;
