model Ex2_20
parameter Real k1(unit = "W/(m.K)")=0.533"thermal conductivity of  Fire Clay ";
parameter Real k2(unit = "W/m.K")=0.7"thermal conductivity of  red brick";
//Case 1
parameter Real A(unit = "sq.m")=1"Area";
parameter Real x1(unit = "m")=0.125"Thickness";
parameter Real x2(unit = "m")=0.5"Thickness";
//Temperatures
parameter Real T1(unit = "K")=1373"Temperature";
parameter Real T2(unit = "K")=323"Temperature";
Real r1(unit = "K/W")"Resistance of fire clay ";
Real r2(unit = "K/W")"Resistance of red brick[";
Real r(unit = "K/W")"Combined Resistance ";
Real Q(unit = "W/sq m")"Heat Transfer";
Real Tdash(unit = "K")"Temperature";
Real x3(unit = "m")"Thickness";
Real r3(unit = "K/W")"Resistance";
Real Tdd(unit = "K")"Temperature";
Real Tm(unit = "K")"Temperature";
Real km(unit = "W/(m.K")"thermal conductivity";
Real x4(unit = "m")"Thickness";
equation
//Resistances
r1=x1/(k1*A); 
r2=x2/(k2*A);  
r=r1+r2;
Q=(T1-T2)/r; 
Tdash=T1-Q*r1;  
//Case2
x3=x2/2;   
r3=x3/(k2*A);  
Tdd= T2+(Q*r3);    
Tm=(Tdash+Tdd)/2;   
km=0.113+(0.00016*Tm);  
x4=km*A*(Tdash-Tdd)/Q;  
end Ex2_20;
