model Ex2_22
import Modelica.Constants.*;
parameter Real Ts(unit = "K")=451"Steam temperature ";
parameter Real Ta(unit = "K")=294"Air temperature";
parameter Real Di(unit = "m")=25/1000"Internal diameter of pipe";
parameter Real od(unit = "m")=33/1000"Outer diameter of pipe ";
parameter Real hi(unit = "W/(m^2.K)")=5678"Inside heat transfer coefficient ";
parameter Real ho(unit = "W/(sq m.K)")=11.36"Outsideheat transfer coefficient ";
parameter Real k2(unit = "W/m.K")=44.97"k for steel ";
parameter Real k3(unit = "W/m.K")=0.175"k for rockwool ";
parameter Real ti(unit = "m")=38/1000"thickness of insulation in ";
parameter Real L(unit="m")=1"Length";
Real xw(unit = "m")"Thickness of steel pipe ";
Real r1(unit = "m")"Internal radius of pipe";
Real r2(unit = "m")"Outer radius of pipe ";
Real rm1(unit = "m")"Log mean radius";
Real r3(unit = "m")"radius of insulation  ";
Real rm2(unit = "m")"Log mean radius";
Real Dm1(unit = "m")"Log mean Dia.";
Real Dm2(unit = "m")"Log mean Dia.";
Real R1(unit = "K/W")"Resistance";
Real R2(unit = "K/W")"Resistance";
Real R3(unit = "K/W")"Resistance";
Real Do(unit = "mm")"Outer radius of insulation ";
Real R4(unit = "K/W")"Resistance";
Real sigma_R(unit = "K/W")"combined Resistance";
Real dT(unit = "K")"Temperature gradient";
Real Q(unit = "W/m")"Heat loss ";
equation
xw=(od-Di)/2;  
r1=Di/2;         
r2=od/2;         
rm1=(r2-r1)/log(r2/r1);     
r3=r2+ti;            
rm2=(r3-r2)/log(r3/r2); 
Dm1=2*rm1;               
Dm2=2*rm2;               
R1=1/(hi*pi*Di*L); 
R2=xw/(k2*pi*Dm1*L);
R3=(r3-r2)/(k3*pi*Dm2*L);
Do=(od+2*ti);          
R4=1/(ho*pi*Do*L);              
sigma_R=R1+R2+R3+R4;
//Heat loss
dT=Ts-Ta;                
Q=dT/sigma_R;            
//Ans varies slightly due to approximation in book
end Ex2_22;

