model Ex2_36
import Modelica.Constants.*;
parameter Real k(unit = "W/sq m.K")=1"Thermal conductivity in ";
parameter Real h(unit = "W/sq m.K")=8"Het transfer coeff";
parameter Real T1(unit = "K")=473"Steam Temperature";
parameter Real T2(unit = "K")=293"Ambient temperature";
parameter Real D(unit="m")=0.11"OD of pipe";
Real r1(unit = "m")"Outer radius =inner radius of insulation";
Real rc(unit="m")"Critical radius";
Real Q_by_L(unit = "W/ m")"heat loss per meter";
Real T(unit="K")"Outer surafce temperature";
equation
r1=D/2;
rc=k/h;  
Q_by_L=2*22/7*(T1-T2)/(log(rc/r1)/k+1/(rc*h));
T=T2+Q_by_L/(rc*2*pi*h);    
end Ex2_36;
