model Ex2_39
import Modelica.Constants.*;
parameter Real h(unit = "W/sq m.K")=11.36"Convection heat transfer coefficient";
parameter Real k_steel(unit = "W/m.K")=43.3"K for steel";
parameter Real r(unit="m")=25.4/1000"radius";
parameter Real rho(unit = "kg/cubic m")=7849"Density";
parameter Real Cp(unit="J/(kg*K")=0.4606*10^3"Cp for steel";
parameter Real t(unit="seconds")=1*3600"Time";
parameter Real T_inf(unit = "K")=394.3"Temperature of medium";
parameter Real T0(unit = "K")=700"Steel ball temperature";
Real A(unit = "sq m")"Area of sphere ";
Real V(unit = "cubic m")"Volume ";
Real Nbi"Biot Number";
Real T(unit = "K")"Temperature of ball after 1h";
equation
A=4*pi*r^2;    
V=A*r/3;  
Nbi=h*(V/A)/k_steel; 
T=T_inf+(T0-T_inf)*(e^((-h*A*t)/(rho*Cp*V)));
end Ex2_39;
