model Ex2_40
import Modelica.Math.*;
parameter Real rho(unit = "kg/cubic m")=9000"Density";
parameter Real Cp(unit="J/(kg*K")=0.38*10^3"Cp for slab";
parameter Real k(unit = "W/m.K")=370"K for copper slab";
parameter Real h(unit = "W/sq m.K")=90"Convection heat transfer coefficient";
parameter Real l(unit = "m")=400/1000"length of copper slab";
parameter Real t(unit = "m")=5/1000 "thickness";
parameter Real T(unit = "K")=363"Re quiredtemperature ";
parameter Real T_inf(unit = "K")=303"Surface temperature";
parameter Real T0(unit = "K")=523"Temperature of slab";
Real A(unit="sq.m")"Area";
Real V(unit = "cubic m")"Volume ";
Real L_dash(unit = "m")"Characterstic length";
Real Nbi"Biot's number";
Real var;
Real t1(unit = "sec")"Time to achieve the desired temperature";
equation
A=2*l^2;     
V=t*l^2;      
L_dash=V/A;    
Nbi=h*L_dash/k;   
var=h*A/(rho*Cp*V);
//As Nbi<0.10,we can apply lumped capacity analysis
((T-T_inf)/(T0-T_inf))=exp(-var*t1 );
// Answer in book is wrong 
end Ex2_40;
