model Ex3_11
parameter Real mu(unit="kg/(m.s)")=1.906*10^(-5)"Viscocity";    
parameter Real k(unit="W/m.K")=0.02723"Thermal conductivity";   
parameter Real Cp(unit="kJ/(kg.K)")=1.007"Specific heat capacity";   
parameter Real R(unit="J/K.mol")=8.3154"Gas Constant";   
parameter Real Npr=0.70"Prandlt number";
parameter Real Mavg=29"Average Molecular weight";
parameter Real u_inf(unit="m/s")=35"velocity";    
parameter Real Tm(unit="K")=313"Temperature";    
parameter Real P(unit="kPa")=101.325"Pressure";    
parameter Real Tw(unit="K")=333"Temperature";    
parameter Real T_inf(unit="K")=293"Temperature"; 
parameter Real L(unit="m")=0.75"Length";  
Real Nre_l"Reynold's no";
Real Nnu"Nusselt no";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of plate";
Real Q(unit="W")"Rate of heat flow";
Real rho(unit="kg/cubic m")"Density";
equation
rho=(P*Mavg)/(R*Tm);
Nre_l=rho*u_inf*L/mu;    //Reynold's number >5*10^5
Nnu=0.0366*Nre_l^(0.8)*Npr^(1.0/3.0);
h=Nnu*k/L;    
A=1*L;    
Q=h*A*(Tw-T_inf);    
end Ex3_11;
