model Ex3_14
import Modelica.Constants.*;
parameter Real v(unit="sq m/s")=2.08*10^(-5)"Viscosity";   
parameter Real k(unit="W/(m.K)")=0.03"Thermal conductivity";   
parameter Real Npr=0.697"Prandlt number";    
parameter Real D(unit="m")=0.06"Diameter";    
parameter Real u_inf(unit="m/s")=0.3"velocity";  
parameter Real Tw(unit="K")=400"Temperature of bulb";    
parameter Real T_inf(unit="K")=300"Temperature of air";     
Real r(unit="m")"Radius ";
Real Nre"Reynold's no";
Real Nnu"Nusselt no";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of sphere";
Real Q(unit="W")"Rate of heat flow";
Real per(unit="%")"Percentage of heat loss";
equation
r=D/2;    
Nre=D*u_inf/v;    
//Average nusselt number is given by:
Nnu=0.37*(Nre^0.6);
h=Nnu*k/D;    
A=4*pi*r^2;    
Q=h*A*(Tw-T_inf);   
per=Q*100/100;    
end Ex3_14;
