model Ex3_2
parameter Real mu(unit="sq m /s")=15*10^(-6)"viscosity";   
parameter Real v(unit="m/s")=2"velocity";   
parameter Real L(unit="m")=2"length of plate";
parameter Real Nre_x=3*10^5"Reynold number";
Real xc(unit="m")"critical length at which the transition takes place";
Real Nre_l"Reynold number";
Real del_l(unit="mm")"Boundary layer thickness";
equation
xc=Nre_x*mu/v;    //critical length at whihc the transition takes place
//Since xc is less than 2 m.Therefore the flow is laminar
//at any distance x,.it is calculated from
Nre_l=v*L/mu;
del_l=4.64*L/sqrt(Nre_l)*1000;
end Ex3_2;
