model Ex3_27
import Modelica.Constants.*;
parameter Real m_dot(unit = "kg/s")=0.217"Water flow rate ";
parameter Real Do(unit = "mm")=19"Outside diameter ";
parameter Real rho(unit="kg/m^3")=1000"Density";
parameter Real t(unit = "mm")=1.6"Wall thickness ";
parameter Real T1(unit = "K")=301"Inlet temperature of water";
parameter Real T2(unit = "K")=315"Outlet temperature of water ";
Real Di(unit = "m")"i.d of tube ";
Real Do1(unit = "m")"o.d of tube";
Real Ai(unit="sq.m")"Area";
Real u(unit = "m/s")"Water velocity through tube";
Real T(unit = "K")"Average Temperature";
Real hi(unit="W/(sq m.K)")"Inside heat transfer coeff based on outside diameter ";
Real hio(unit="W/(sq m.K)")"Inside heat transfer coeff based on outside diameter";
equation
Di=(Do-2*t)/1000;   
Do1=Do/1000;  
Ai=pi*(Di/2)^2; 
u=m_dot/(rho*Ai);  
T=(T1+T2)/2; 
hi=(1063*(1+(0.00293*T))*(u^0.8))/(Di^0.20);
hio=hi*(Di/Do1);  
//Calculation in book is wrong due to slight approximation
end Ex3_27;
