model Ex3_28
parameter Real mair_dot(unit = "kg/s")=0.90"Mass flowrate";
parameter Real T1(unit = "K")=283"Initial Temperature";
parameter Real T2(unit = "K")=366"Final  Temperature";
parameter Real Di(unit = "m")=12/1000"pipe diameter";
parameter Real G(unit = "kg/(sq m.s)")=19.9"Mass flow velocity";
parameter Real mu(unit = "N.s/sq m")=0.0198*10^(-3)"Viscocity";
parameter Real k(unit = "W/(m.K)")=0.029"Thermal conductivity";
parameter Real Cp(unit = "kJ/kg.K")=1"Specific heat capacity";
parameter Real ho(unit = "W/(m^2.K)")=232"Heat transfer Co-efficient";
parameter Real T(unit = "K")=700"Inlet Temperature of flue gas";
Real Cp1(unit = "J/kg.K")"Specific heat capacity";
Real dT(unit = "K")"Temperature gradient";
Real Nre"Reynold number";
Real Npr"Prandlt number";
Real hi(unit = "W/sq m.K")"Heat transfer coefficient";
Real U(unit = "W/m^2.K")"Overall heat transfer coefficient ";
Real Q(unit = "J/s")"Heat flow";
Real dT1(unit = "K")"Temperature gradient of flue gas";
Real dT2(unit = "K")"Temperature gradient of air";
Real dTm(unit = "K")"Log mean temperature diffrence";
Real A(unit="sq.m")"Area";
equation
Cp1=Cp*10^3;
dT=(T1+T2)/2;   
Nre=Di*G/mu; 
Npr=Cp1*mu/k; 
//Dittus-Boelter equation is
hi=0.023*(Nre^0.8)*(Npr^0.4)*k/Di;   
U=1/(1/hi+1/ho);
Q=mair_dot*Cp*(T2-T1)*10^3;  
dT1=T-T2;   
dT2=T2-T1;  
dTm=(dT1-dT2)/log(dT1/dT2);  
//Q=U*A*dTm
A=Q/(U*dTm);
end Ex3_28;
