model Ex3_29
parameter Real v(unit = "sq m./s")=18.41*10^(-6)"Viscocity ";
parameter Real k(unit = "W/m.K")=28.15*10^(-3)"Thermal conductivity";
parameter Real Npr=0.7"Prandtl number";
parameter Real Beta(unit="1/K")=3.077*10^(-3)"Volume expansion coefficient";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real Tw(unit = "K")=350"Temperature of solid surface";
parameter Real T_inf(unit = "K")=300"Average Temperature";
parameter Real L(unit = "m")=0.3"Length";
parameter Real u_inf(unit = "m/s")=4"velocity";
Real dT(unit = "K")"Temperature gradient";
Real Ngr"Grashof number";
Real Nnu"Nusselt number";
Real h(unit = "W/sq m.K")"Average heat transfer coefficient";
Real Nre_l"Reynold number";
Real Nnu1"Nusselt number";
Real h1(unit = "W/sq m.K")"Heat Transfer co-effcient";
equation
dT=Tw-T_inf; 
//1.Free Convection
Ngr=(g*Beta*dT*L^3)/(v^2); 
Nnu=0.59*(Ngr*Npr)^(1.0/4.0);   
h=Nnu*k/L;   
//2.Forced Convestion
Nre_l=u_inf*L/v;
Nnu1=0.664*(Nre_l^(1/2))*(Npr^(1.0/3.0));   
h1=Nnu1*k/L;  
end Ex3_29;
