model Ex3_32
import Modelica.Constants.*;
parameter Real k(unit = "W/m.K")=0.630"Thermal conductivity";
parameter Real Beta(unit="K^-1")=3.04*10^(-4)"Volume expansion coefficient";
parameter Real rho(unit="kg/m^3")=1000"Density";
parameter Real mu(unit = "kg/(m.s)")=8.0*10^(-4)"viscocity";
parameter Real Cp(unit = "KJ/kg.K")=4.187"Specific heat capacity  ";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real Tw(unit = "K")=313"Temperature of heater";
parameter Real T_inf(unit = "K")=298"Temperature of water";
parameter Real D(unit = "m")=20/1000"Dimaeter";
Real dT(unit = "K")"Temperature gradient";
Real Ngr"Grashof number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real h(unit = "W/ sq.m.K")"Heat Transfer coefficient";
Real Q_by_l(unit = "W/m")"Heat loss per unit length ";
equation
dT=Tw-T_inf;
Ngr=9.81*(rho^2)*Beta*dT*(D^3)/(mu^2);  
Npr=(Cp*1000*mu)/k; 
//Average nusselt number is
Nnu=0.53*(Ngr*Npr)^(1.0/4.0);
h=Nnu*k/D;  
Q_by_l=h*pi*D*dT;
//Ans varies due to approximation.   
end Ex3_32;
