model Ex3_34
import Modelica.Constants.*;
parameter Real rho(unit = "kg/m^3")=960.63"Density";
parameter Real Cp(unit = "J/(kg.K)")=4.216*10^3"Specific heat";
parameter Real D(unit = "m")=16/100"Diameter ";
parameter Real k(unit = "W/m.K")=0.68"Thermal conductivity";
parameter Real Beta(unit = "K^-1")=0.75*10^(-3)"Volume expansion coefficient";
parameter Real alpha(unit = "m^2/s")=1.68*10^(-7)"Thermal Diffusivity";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real Tw(unit = "K")=403"Tempearture of horizontal plate";
parameter Real T_inf(unit = "K")=343"Tempearture of water";
parameter Real v(unit = "m^2/s")=0.294*10^(-6)"Kinematic diffusivity";
Real A(unit="sq.m")"Area";
Real L(unit = "m")"Length=A/P ";
Real dT(unit = "K")"Temerature gradient";
Real Nra"rayleigh number";
Real Nnu"Nusselt number";
Real ht(unit="W/sq.m.K")"Heat transfer co-efficient for top surface";
Real Nnu1"Nusselt number";
Real hb(unit = "W/sq m.K")"Heat transfer co-efficient for bottom surface";
Real Q(unit = "W")"rate of heat input ";
equation
A=(pi*(D/2)^2);
L=A/(pi*D);   
dT=Tw-T_inf;
Nra=(g*Beta*(L^3)*dT)/(v*alpha); 
//1.For Top surface
Nnu=0.15*(Nra)^(1.0/3.0);   
ht=Nnu*k/L;  
//2.For bottom surface
Nnu1=0.27*Nra^(1.0/4.0); 
hb=Nnu1*k/L;  
Q=(ht+hb)*A*dT;
//Value of v considered in solution differs from  one given as input data in the book.Typo Error in the book. 
end Ex3_34;
