model Ex3_38
import Modelica.Constants.*;
parameter Real v(unit = "m^2/s")=23.13*10^(-6)"Kinematic viscocity";
parameter Real k(unit = "W/m.K")=0.0321"Thermal conductivity";
parameter Real Beta(unit = "K^-1")=2.68*10^(-3)"Volume expansion coefficient";
parameter Real Tw(unit = "K")=443"Temperature of pipe wall ";
parameter Real T_inf(unit = "K")=303"Temperature of air ";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
parameter Real Npr=0.688"Prandtl number";
parameter Real D(unit = "m")=100/1000"Diameter ";
parameter Real e=0.90"Emissivity";
parameter Real sigma(unit="W/sq.m.K^4")=5.67*10^(-8)"Stefan boltzman constant";
Real dT(unit = "K") "Temerature gradient";
Real Nra"rayleigh number";
Real Nnu "Nusselt number";
Real h(unit = "W/sq m.K") "Average heat transfer coefficient";
Real Q_by_l(unit = "W/m")"total heat  loss per meter length";
equation
dT=Tw-T_inf;   
Nra=(g*Beta*dT*(D^3)*Npr)/(v^2);
Nnu=0.53*(Nra^(1.0/4.0));    
h=Nnu*k/D;   
//Q=Q_conv+Q_rad  //Total heat loss
//for total heat  loss per meter length
Q_by_l=h*pi*D*dT+sigma*e*pi*D*(Tw^4-T_inf^4);  
end Ex3_38;
