model Ex3_49
import Modelica.Constants.*;
parameter Real rho(unit = "kg/m^3")=1174"Density";
parameter Real k(unit = "W/(m.K)")=0.069"thermal conductivity";
parameter Real mu(unit = "N.s/m^2")=2.5*10^(-4)"viscocity";
parameter Real lambda(unit = "KJ/kg")=132"Latent heat-enthaply of vaporisation";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real Ts(unit = "K")=323"Saturation temperature of steam ";
parameter Real Tw(unit = "K")=313"Temperature of tube surface";
//For square array,n=4
parameter Real n=4"number of tubes";
parameter Real Do(unit = "m")=12/1000"Od of tube";
parameter Real n1=16" for heat transfer area calculation";
Real dT(unit = "K")"Temperature gradient";
Real h(unit = "W/sq m.K")"Convective heat transfer coeff";
Real A(unit = "sq m")"Area ";
Real Q(unit = "W")"Heat Transfer rate";
Real m_dot(unit = "kg/h")"Condensation rate";
equation
dT=Ts-Tw;    
h=0.725*(rho^2*lambda*10^3*g*k^3/(n*Do*mu*dT))^(1/4); 
//For heat transfer area calcualtion,n=16
A=n1*pi*Do; 
Q=h*A*dT;  
m_dot=(Q/(lambda*10^3))*3600;  
//Ans varies due to approximation
end Ex3_49;
