model Ex3_6
parameter Real P1(unit="kPa")=101.325"Pressure";    
parameter Real mu1(unit="sq m /s")=30.8*10^(-6)"Kinematic viscosity";  
parameter Real k(unit="W/(m.K)")=36.4*10^(-3)"Thermal conductivity";    
parameter Real Npr=0.69"Prandlt number";
parameter Real u_inf(unit="m/s")=8"viscosity";
parameter Real Cp(unit="kJ/(kg.K")=1.08"Specific heat capacity";
parameter Real L(unit="m")=1.5"Length of plate";    
parameter Real W(unit="m")=0.3"Width";    
parameter Real P2(unit="kPa")=8"Pressure";    
parameter Real T_inf(unit="K")=523"Temperature";    
parameter Real Tw(unit="K")=353"Temperature";   //in Que it is 253 and in solution is is 353. Hence considered 353. 
Real A(unit="sq m")"Area of plate";
Real mu2(unit="sq m /s")"Kinematic viscosity";
Real Nre_l"Reynold's no";
Real Nnu"Nusselt no.";
Real h(unit="W/(sq.m.K)")"Convective heat transfer co-efficient";
Real Q(unit="W")"Rate of heat removal";
equation
A=L*W;    
//At constant temperature: mu1/mu2=P2/P1
mu2=mu1*P1/P2;    
Nre_l=u_inf*L/mu2;    //.
//Since this is less than 3*10^5
Nnu=0.664*sqrt(Nre_l)*(Npr^(1.0/3.0));
h=Nnu*k/L;  
Q=2*h*A*(T_inf-Tw);    
end Ex3_6;
