model Ex3_7
parameter Real rho(unit="kg/cubic m")=0.998"Density";    
parameter Real v(unit="sq m/s")=20.76*10^(-6)"kinematic viscocity";    
parameter Real k(unit="W/m.K")=0.03"Thermal conductivity";    
parameter Real u_inf(unit="m/s")=3"viscosity";    
parameter Real x(unit="m")=0.4"length";   
parameter Real w(unit="m")=1.5"width";    
parameter Real Cp(unit="J/kg.K")=1.009*1000"Specific heat capacity";   
parameter Real Tw(unit="k")=407"Temperature";   
parameter Real T_inf(unit="K")=293"Temperature";    
Real Nre_x"Reynold's no";
Real mu(unit="kg/m .s")"Kinematic viscosity";
Real Npr"prandlt number";
Real Nnu_x"Nusselt No.";
Real hx(unit="W/(m.K)")"Convective heat transfer co-efficient";
Real h(unit="W/(m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of plate";
Real Q(unit="W")"Rate of heat flow";
Real Q1(unit="W")"Rate of heat flow from both sides of plate ";
equation
Nre_x=u_inf*x/v;    //Reynolds no at x=0.4 m
mu=rho*v;  
Npr=Cp*mu/k;
Nnu_x=0.332*(sqrt(Nre_x))*(Npr^(1.0/3.0));
hx=Nnu_x*k/x;    //[]
h=2*hx;   
A=x*w;   
Q=h*A*(Tw-T_inf);     
//From both sides of the plate:
Q1=2*Q;   
//Ans in book varies due to approximation
end Ex3_7;
