model Ex4_11
import Modelica.Constants.*;
parameter Real sigma(unit=("W/(m^2.K^4)"))=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e1=0.3"Emissivity of inner sphere ";
parameter Real e2=0.3"Emissivity of outer sphere ";
parameter Real D1(unit = "m")=0.3"Diameter of inner sphere ";
parameter Real D2(unit = "m")=0.5"Diameter of outer sphere ";
parameter Real T1(unit = "K")=90"Temperature of oxygen";
parameter Real T2(unit = "K")=313"Temperature of outer sphere";
parameter Real e3=0.05"Emissivity of polished aluminium  ";
parameter Real e4=0.5"Emissivity of aluminium  ";
Real A1(unit = "sq m")"Area of inner sphere ";
Real A2(unit = "sq m")"Area of outer sphere ";
Real Q1(unit = "W")"Rate of heat flow";
Real Q2(unit = "W")"Rate of heat flow";
Real Red(unit="%")"Percent Reduction";
equation
A1=pi*D1^2; 
A2=pi*D2^2;
Q1=(sigma*A1*(T1^4-T2^4)/(1/e1+(A1/A2)*(1/e2-1)));  
//When Aluminium is used
Q2=(sigma*A1*(T1^4-T2^4)/(1/e3+(A1/A2)*(1/0.3-1)));  
Red=abs((Q1-Q2)*100/Q1);  
end Ex4_11;
