model Ex4_15
parameter Real sigma(unit = "W/(m^2.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e1=0.4"Emissivity of first plane ";
parameter Real e2=0.5"Emissivity of radiation shield";
parameter Real e3=0.2"Emissivity of second plane";
parameter Real T1(unit = "K")=473"Temperature of first plane";
parameter Real T3(unit = "K")=303"Temperature of second plane ";
Real Q_by_a(unit = "W/sq m")"Heat transfer without shield";
Real T2(unit = "K")"Temperature of shield";
Real Q1_by_a(unit = "W/sq m")"Heat transfer with shield";
Real red(unit = "%")"Reduction in heat loss";
equation
Q_by_a=sigma*(T1^4-T3^4)/((1/e1)+(1/e3)-1);  
T2=((6/9.5)*((3.5/6)*T3^4+T1^4))^(1/4);  
Q1_by_a=sigma*(T1^4-T2^4)/((1/e1)+(1/e2)-1); 
red=(Q_by_a-Q1_by_a)*100/Q_by_a;
end Ex4_15;
