model Ex4_21
parameter Real e1=0.3"Emissivity of plane A";
parameter Real e2=0.8"Emissivity of plane B";
parameter Real e3=0.04"Emissivity of shield";
parameter Real F13=1"Shape factor";
parameter Real F32=1"Shape factor";
//Let sigma*(T1^4-T2^4)=z=1(const)
parameter Real z=1"const";
Real Q_by_A(unit="W/sq m")"Heat transfer without shield";
Real R1"Resistance 1";
Real R2"Resistance 2";
Real R3"Resistance 3";
Real R4"Resistance 4";
Real R5"Resistance 5";
Real R6"Resistance 6";
Real R"Total resistance";
Real Q_by_As(unit="W/sq m")"Heat transfer with shield";
Real red(unit="%")"Reduciton in heat tranfer due to shield";
equation
Q_by_A=z/(1/e1+1/e2-1); 
//The resistances are:
R1=(1-e1)/e1;
R2=1/F13;
R3=(1-e3)/e3;
R4=R3;
R5=1/F32;
R6=(1-e2)/e2;
R=R1+R2+R3+R4+R5+R6;     
Q_by_As=z/R; //where z=sigma*(T1^4-T2^4
red=(Q_by_A-Q_by_As)*100/Q_by_A;  
end Ex4_21;
