model Ex4_4
import Modelica.Constants.*;
parameter Real e=0.9"Emissivity"; 
parameter Real L(unit="m")=1"length"; 
parameter Real Do(unit="m")=50/1000"Diameter of pipe"; 
parameter Real sigma(unit="W/m^2.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit="K")=415"Temperature of grey body"; 
parameter Real T2(unit="K")=290"Temperature of surrounding"; 
Real dT(unit="K")"Temperature gradient";
Real hc(unit="W/sq.m.K")"film coefficient";
Real A(unit="sq.m.")"Area";
Real Qc(unit="W/m")"heat loss by convection";
Real Qr(unit="W/m")"heat loss by radiation";
Real Qt(unit="W/m")"heat loss by convection and  radiation";
equation
dT=T1-T2;    
hc=1.18*(dT/Do)^(0.25);  
A=pi*Do*L; 
Qc=hc*A*dT; 
Qr=e*sigma*A*(T1^4-T2^4);    
Qt=Qc+Qr;  
// varies slightyly due to approximation in book.  
end Ex4_4;
