model Ex4_5
import Modelica.Constants.*;
parameter Real e=0.85"Emissivity";
parameter Real sigma(unit="W/m^2.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit="K")=443"Temperature of grey body"; 
parameter Real T2(unit="K")=290"Temperature of surrounding";
parameter Real Do(unit="m")=60/1000"Diameter of pipe"; 
parameter Real L(unit="m")=6"length"; 
Real dT(unit="K")"Temperature gradient";
Real hc(unit="W/sq.m.K")"film coefficient";
Real A(unit="sq.m.")"Area";
Real Qc(unit="W")"heat loss by convection";
Real Qr(unit="W")"heat loss by radiation";
Real Qt(unit="W")"heat loss by convection and  radiation";
equation
dT=T1-T2;    
hc=1.64*dT^0.25;     
A=pi*Do*L;  
Qr=e*sigma*A*(T1^4-T2^4);    
Qc=hc*A*(T1-T2); 
Qt=Qr+Qc; 
//Ans varies slightyly due to approximation in book.   
end Ex4_5;
