model Ex5_10
import Modelica.Constants.*;
parameter Real m_dot(unit = "kg/h")=7250"Mass flowrate of Nitrobenzene" ;
parameter Real Cp(unit = "kJ/kg.K")=2.387"Specific heat capacity ";
parameter Real mu(unit = "kg/m.s")=7*10^(-4)"Viscocity";
parameter Real k(unit = "W/m.K")=0.151"Thermal conductivity";
parameter Real vis=1"viscocity correction factor";
parameter Real Ft=0.9"LMTD correction factor";
parameter Real T1(unit = "K")=400"Inlet Temperature of Nitrobenzene ";
parameter Real T2(unit = "K")=317"Outlet Temperature of Nitrobenzene";
parameter Real t1(unit = "K")=333"Inlet Temperature of benzene";
parameter Real t2(unit = "K")=300"Outlett Temperature of benzene";
parameter Real n=170"No. of tubes";
parameter Real L(unit = "m")=5"Length";
parameter Real Do(unit = "m")=0.019"Outer Dia.";
parameter Real Di(unit = "m")=0.015"Inner Dia.";
parameter Real B(unit = "m")=0.15"Baffle spacing ";
parameter Real Pt(unit = "m")=0.025"Tube pitch ";
parameter Real id(unit = "m")=0.45"Inner Dia.";
parameter Real hi(unit = "W/sq m.K")=1050"Heat transfer coefficient";
parameter Real Rd_given(unit = "W/sq m.K")=9*10^(-4)"dirt factor";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Q(unit = "W")"Rate of heat transfer";
Real Ao(unit = "sq m")"Area";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real C_dash(unit = " m")"clearance";
Real as(unit = "sq m")"Shell side cross flow area";
Real De(unit = "m")"shell equivalent diameter";
Real Gs(unit = "kg/m^2.s")"Mass velocity";
Real Cp1(unit="J/kg.K")"Specific heat capacity";
Real Nre"Reynolds number";
Real Npr"Prandtl number";
Real mu_w(unit = "kg/m.s")"Viscocity";
Real Nnu"Nusselt number";
Real ho(unit = "W/sq m.K")"Convective heat transfer coeficient";
Real Uo1(unit = "W/sq m K")"Overall heat transfer coefficient";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Rd(unit="W/m^2.K/")"dirt factor";
equation
dT1=T1-t1;          
dT2=T2-t2;         
dTlm=(dT1-dT2)/log(dT1/dT2);       
//For nitrobenzene
Q=m_dot*Cp*(T1-T2)*1000/3600;          
Ao=n*pi*Do*L;      
Uo=Q/(Ao*Ft*dTlm);   
Ud=Uo;           
C_dash=Pt-Do;        
//Shell side cross flow area
as=id*C_dash*B/Pt;          
//Equivalent diameter of shell
De=4*(Pt^2-(pi/4)*(Do^2))/(pi*Do);       
//Mass velocity on shell side
Gs=(m_dot/as)/3600;          
Cp1=Cp*1000;      
Nre=De*Gs/mu;        
Npr=Cp1*mu/k;        
//From empirical eqn:
mu_w=mu;         //
Nnu=0.36*Nre^0.55*Npr^(1/3);
ho=Nnu*k/De;         
Uo1=1/(1/ho+(1/hi)*(Do/Di));     
Uc=Uo1;              
//Suitability of heat exchanger
Rd=(Uc-Ud)/(Uc*Ud);        
end Ex5_10;
