model Ex5_11
import Modelica.Constants.*;
parameter Real mw_dot(unit = "kg/h")=1720"Mass flowrate of water";
parameter Real t1(unit = "K")=293"Inlet Temperature of Water ";
parameter Real t2(unit = "K")=318"Outlet Temperature of Water";
parameter Real Cpw(unit = "kJ/kg.K")=4.28"Specific heat capacity";
parameter Real lambda(unit = "kJ/kg")=2230"Latent heat of vaporisation of steam ";
parameter Real dT1(unit = "K")=90"Temperature gradient ";
parameter Real dT2(unit = "K")=65"Temperature gradient ";
parameter Real Di(unit = "m")=0.0225"ID. of tube";
parameter Real u(unit = "m/s")=1.2"Velocity";
parameter Real rho(unit = "kg/m^3")=995.7"Density";
parameter Real v(unit = "m/s")=0.659*10^(-6)"Velocity";
parameter Real k(unit = "W/m.K")=2.54*1000/3600"Thermal conductivity";//Converted from KJ/(h.m.k) into W/m.K
parameter Real ho(unit = "W/m^2.K")=19200*1000/3600"Convective heat transfer coeficient";
parameter Real Do(unit = "m")=0.025"OD. of tube";
parameter Real kt(unit = "W/m.K")=460*1000/3600"Thermal conductivity For tube wall material ";
parameter Real L(unit = "m")=4"Tube length ";
Real Q(unit = "W")"Rate of heat transfer";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real mu(unit = "kg/m.s")"Viscosity";
Real Nre"reynolds number";
Real Cp(unit = "J/kg.K")"Specific heat capacity";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real hi(unit = "W/sq m.K")"inside heat transfer coefficient";
Real Dw(unit = "m")"Log mean diameter";
Real x(unit = "m")"Thickness";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Ao(unit = "sq  m")"Area";
Real n"Number of tubes";
equation
Q=mw_dot*Cpw*(t2-t1)*1000/3600;     
dTlm=(dT1-dT2)/log(dT1/dT2);     
//Calculation of inside heat transfer coefficient
mu=v*rho;        
Nre=Di*u*rho/mu;     
Cp=Cpw*1000;         
Npr=Cp*mu/k;             
Nnu=0.023*Nre^0.8*Npr^0.4;       
hi=k*Nnu/Di;             
Dw=(Do-Di)/log(Do/Di);       
x=(Do-Di)/2;    
Uo=1/(1/ho+(1/hi)*(Do/Di)+(x/kt)*(Do/Dw));        
Ao=Q/(Uo*dTlm);          
n=Ao/(pi*Do*L);         
end Ex5_11;
