model Ex5_21
import Modelica.Constants.*;
parameter Real mc_dot(unit = "kg/s")=3.783"Cold water flow rate";
parameter Real mh_dot(unit = "kg/s")=1.892"Hot water flow rate ";
parameter Real Cpc(unit = "kJ/(kg.K)")=4.18"Sp heat of cold water ";
parameter Real T1(unit = "K")=367"Inlet Temperature of Hot water";
parameter Real t2(unit = "K")=328"outlet Temperature of cold water";
parameter Real t1(unit = "K")=311"Inlet Temperature of cold water";
parameter Real Cph(unit = "kJ/(kg.K)")=4.18"Specific heat of hot water ";
parameter Real rho(unit = "kg/m^3")=1000"Density ";
parameter Real D(unit = "m")=0.019"Diameter of tube ";
parameter Real U(unit = "W/sq m.K")=1450 "Overal heat transfer coefficient ";
parameter Real Ft=0.88"LMTD correction factor";
parameter Real u(unit = "ms^-1")=0.366"Velocity through tubes";
parameter Real L(unit = "m")=1"Per m length";
Real T2(unit="K")"outlet Temperature of Hot water";
Real Q(unit="W")"rate of heat transfer";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real lmtd(unit="K")"Log mean temperature differnece";
Real A(unit="sq.m")"Area";
Real Ai(unit="sq.m")"Total flow Area";
Real n"No. of tubes";
Real sa(unit="m^2/m")"S.S per tube per 1 m length";
Real L1(unit="m")"Length of tubes";
Real A1(unit="sq.m")"Area";
Real L2(unit="m")"Length";
equation   
T2=T1-mc_dot*Cpc*(t2-t1)/(mh_dot*Cph); 
Q=mc_dot*Cpc*(t2-t1)*1000;                    
//For counterflow heat exchanger
dT1=T1-t2;                  
dT2=17;                    
dTlm=(dT1-dT2)/log(dT1/dT2);
lmtd=dTlm;                   
A=Q/(U*dTlm);               
Ai=mc_dot/(rho*u);          
n=Ai/((pi/4)*(D^2));         
sa=pi*D*L;                 
L1=A/(abs(n)*pi*D);               
//For 2passes on the tube side
A1=Q/(U*Ft*lmtd);     
L2=A1/(2*n*pi*D);
//Ans varies due to approximation in book     
end Ex5_21;
