model Ex6_11
import Modelica.Constants.*;
parameter Real mf_dot(unit = "kg/h")=10000"Mass flowrate of feed ";
parameter Real ic=0.09"Initial concentration ";
parameter Real fc=0.47"Final concentration";
parameter Real Ps(unit = "kPa")=686.616+101.325"Steam pressure ";
parameter Real Ts(unit = "K")=442.7"Saturation temperature ";
parameter Real P2(unit = "kPa")=86.660"Vacuum in second effect ";
parameter Real U1(unit = "W/sq m.K")=2326"Overall heat transfer in first effect ";
parameter Real U2(unit = "W/sqm.K")=1744.5"Overall heat transfer in 2nd effect ";
parameter Real T2(unit = "K")=326.3"Temperature in 2nd effect ";
parameter Real Tf(unit = "K")=309"Feed temperature ";
parameter Real T(unit = "K")=273"temperature";
parameter Real Cpf(unit="kJ/kg.K")=3.77"  Specific heat for all caustic streams";
//For steam at 442.7 K
parameter Real lambda_s(unit = "kJ/kg")=2048.7"latent heat of condensing steam";
////For vapour at 392.8 K
parameter Real Hv1(unit = "kJ/kg")=2705.22"enthalpy of vapour";
parameter Real lambda_v1(unit = "kJ/kg")=2202.8"latent heat of vaporization of caustic soda ";
////for vapour at 326.3 K:
parameter Real Hv2(unit = "kJ/kg")=2597.61"enthalpy of vapour in 2nd effect";
parameter Real lambda_v2(unit = "kJ/kg")=2377.8"latent heat of vaporization of caustic soda in second effect ";
//Vapour at 388.5 K
parameter Real Hv12(unit = "kJ/kg")=2699.81"enthalpy of vapour";
parameter Real lambda_v12(unit = "kJ/kg")=2214.92"latent heat of vaporization";
Real m1dot_dash(unit = "kg/h")"Mass flow rate of thick liquor ";
Real P2_abs(unit = "kPa")"Absolute pressure in second effect";
Real dT(unit = "K") "Temperature gradient";
Real dT2(unit = "K")"Temperature gradient in 2nd effect";
Real dT1(unit = "K")"Temperature gradient in 1st effect";
Real Tv1(unit = "K")"Temperature in vapor space of first effect";
Real Tv2(unit = "K")"Temperature in vapor space of second effect";
Real Hf(unit = "kJ/kg")"Feed enthalpy";
Real H1dash(unit = "kJ/kg")"Enthalpy of final product";
Real H2dash(unit="kJ/kg")"Enthalpy of intermediate product";
Real mv_dot(unit = "kg/h")"steam evaporated ";
Real mv1_dot(unit = "kg/h")"steam evaporated in first effect ";
Real mv2_dot(unit = "kg/h")"steam evaporated in second effect ";
Real m2dot_dash(unit = "kg/h")"First effect material balance";
Real ms_dot(unit = "kg/h")"Steam consumption ";
Real lambda_v11(unit = "kJ/kg")"latent heat of vaporization of caustic soda ";
Real A1(unit = "sq m")"Heat trasnfer area first effect";
Real A2(unit = "sq m")"Heat trasnfer area second effect";
Real Aavg(unit = "sq m")"Avg heat transfer";
Real dT1_dash(unit = "K")"Temperature gradient";
Real dT2_dash(unit = "K")"Temperature gradient";
Real Tv11(unit = "K")"Temperature in vapor space of first effect";
Real Tv21(unit = "K")"Temperature in vapor space of first effect";
Real H1dash1(unit = "kJ/kg")"Enthalpy of final product";
Real mv1_dot1(unit = "kg/h")"steam evaporated in first effect ";
Real mv2_dot1(unit = "kg/h")"steam evaporated in second effect ";
Real lambda_s1(unit = "kJ/kg")"latent heat of condensing steam";
Real A11(unit = "sq m")"Heat trasnfer area first effect";
Real A21(unit = "sq m")"Heat trasnfer area second effect";
Real ms_dot1(unit = "kg/h")"Steam flow rate";
equation
m1dot_dash=ic*mf_dot/fc;     
P2_abs=101.325-P2;   
dT=Ts-T2;        
dT2=dT/1.75;     
dT1=(U2/U1)*dT2;    
//Since there is no B.P.R
Tv1=Ts-dT1;      
Tv2=Tv1-dT2;     
Hf=Cpf*(Tf-T);       
H1dash=Cpf*(Tv1-T);      
H2dash=Cpf*(Tv2-T);      
//Overall material balance:
mv_dot=mf_dot-m1dot_dash;        
mv1_dot=(H2dash*(mf_dot-mv_dot)-mf_dot*Hf+mv_dot*Hv2)/(Hv2+lambda_v1-H2dash);  
mv2_dot=mv_dot-mv1_dot;              
m2dot_dash=m1dot_dash+mv1_dot;           
ms_dot=(mv1_dot*Hv1+m1dot_dash*H1dash-m2dot_dash*H2dash)/lambda_s;    
//First effect
A1=ms_dot*lambda_s*(10^3)/(3600*U1*dT1);    
//Second effect
lambda_v11=lambda_v1*(10^3/3600);
A2=mv1_dot*lambda_v11/(U2*dT2);       
//Since A1 not= A2
//SECOND TRIAL
Aavg=(A1+A2)/2;          
dT1_dash=dT1*A1/Aavg;        
dT2_dash=dT-dT1_dash;         
//Temperature distribution
Tv11=Ts-dT1_dash;       
Tv21=Tv11-dT2_dash;            
H1dash1=Cpf*(Tv11-T);      
mv1_dot1=(H2dash*(mf_dot-mv_dot)-mf_dot*Hf+mv_dot*Hv2)/(Hv2+lambda_v12-H2dash);  
mv2_dot1=mv_dot-mv1_dot1;  //[kg/h]
//First effect Energy balance
(ms_dot1*lambda_s+(mf_dot-mv2_dot1)*H2dash)=(mv1_dot1*Hv12+m1dot_dash*H1dash1);    
//Area of heat transfer
lambda_s1=lambda_s*1000/3600;     
A11=ms_dot1*lambda_s1/(U1*dT1_dash);        
//Second effect:
A21=mv1_dot*lambda_v1*1000/(3600*U2*dT2_dash);  
// Ans varies Slightly as value of Cpf is considered as 3.768 instead of 3.77     
end Ex6_11;
