model Ex6_16
parameter Real bpr(unit = "K")=40.6"Boiling point rise";
parameter Real Cpf(unit = "kJ/kg.K")=1.88"Specific heat capacity of feed ";
parameter Real Hf(unit = "kJ/kg")=214"enthalpy of 20% NaOH";
parameter Real H1(unit = "kJ/kg")=505"enthalpy of 50% NaOH";
parameter Real mf_dot(unit = "kg/h")=4536"mass flowrate of feed solution";
parameter Real ic=0.2"Initial conc";
parameter Real fc=0.5"Final concentration";
parameter Real Ts(unit = "K")=388.5"Saturation temperature of steam ";
parameter Real bp(unit = "K")=362.5"b.P of solution ";
parameter Real lambda_s(unit = "kJ/kg")=2214"latent heat of condensing steam";
parameter Real P(unit = "kPa")=21.7"Vapor space ";
parameter Real Hv(unit = "kJ/kg")=2590.3"enthalpy of vapour";
parameter Real U(unit = "W/sq m.K")=1560"Overall Heat transfer Coefficient";
Real m1dot_dash(unit = "kg/h")"Thick liquor flowarte";
Real mv_dot(unit = "kg/H")"Water evoparated ";
Real ms_dot(unit = "kg/h")"mass flowrate of steam";
Real dT(unit = "K")"Temperature gradeient";
Real Q(unit = "w")"Rate of Heat transfer";
Real A(unit="Sq.m")"Area";
Real Hv1(unit = "kJ/kg")"enthalpy of vapor";
Real ms_dot1(unit = "kg/h")"Steam consumption ";
Real eco"Steam economy";
Real Q1(unit = "w")"Rate of Heat transfer";
Real A2(unit="Sq.m")"Area";
Real perc(unit="%")"error in the heat transfer area ";
equation
m1dot_dash=(ic/fc)*mf_dot;       
mv_dot=mf_dot-m1dot_dash;        
//Enthalpy balance over evaporator
ms_dot=(m1dot_dash*H1+mv_dot*Hv-mf_dot*Hf)/lambda_s;     
dT=Ts-bp;        
Q=ms_dot*lambda_s*1000/3600;              
A=Q/(U*dT);      
Hv1=Hv+Cpf*bpr;  
ms_dot1=(m1dot_dash*H1+mv_dot*Hv1-mf_dot*Hf)/lambda_s;   
eco=mv_dot/ms_dot1;      
Q1=ms_dot1*lambda_s*1000/3600;           
A2=Q1/(U*dT);              
perc=(A2-A)*100/A;          
end Ex6_16;
