model Ex4_9
parameter Real e(unit="C")=-1.6*10^(-19)"charge on electron";
parameter Real q(unit="C")=20*10^(-6)"charge";
parameter Real r1(unit="m")=0.1"distance";
parameter Real r2(unit="m")=0.05"distance";
parameter Real k(unit="N M/C^2")= 9*10^(9);//1/4*pi*eo=9*10^(9)
Real Va"unit=V";
Real Vb"unit=V";
Real V"unit=V";
Real W"unit=J";
equation
Va=k*(q/r1);  //calculating voltage at A
Vb=k*(q/r2);  //calculating voltage at B
V=Va-Vb;    //potential difference
W=V*e;     //calculating work done in joule

end Ex4_9;
