//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1: Fundamental Concepts
//Example : 1.11 page 15
//Topic:A horizontal steel pipe
//==============================================================================

model Ex1_11
extends Modelica.Constants;

//========================
//Parameter section
 
parameter Real h(unit = "W/m^2*K")=6.5"Heat transfer coefficient between surface and surrounding air";
parameter Real em=0.8"Emissivity of steel";
parameter Real d(unit = "mm")=80"Outer diameter of steel pipe";
parameter Real T1(unit = "degree celcius")=60"Temperature of steel pipe";
parameter Real T2(unit = "degree celcius")=20"Air and wall temperature";
parameter Real L(unit = "m")=1"Length of the pipe";//In this problem its unit length

//=========================
//Variable section

Real Q(unit = "W/m")"Heat loss by the pipe";
Real A(unit = "m^2")"Surface area of pipe";

//=========================
//Equation section

equation
A=(pi*d*L)/1000;
Q=(h*A*(T1-T2))+(em*sigma*A*((T1+273.15)^4-(T2+273.15)^4));
end Ex1_11;

//=====================================================
//Remarks
//The value of h=6.5,but substituted wrongly as 65.
 
