//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1:Fundamental Concepts
//Example :1.6 page 9
//Topic:Thin hot vertical plate

//========================================================================
model Ex1_6

//==================
//Parameter section

parameter Real dt(unit="K/s")=0.02"Change in temperature with time";
parameter Real A(unit="m^2")=0.1"Surface area of plate";
parameter Real Tp(unit="degree celcius")=225"Plate temperature";
parameter Real Ta(unit="degree celcius")=25"Ambient temperature";
parameter Real m(unit="kg")=4"Mass of the plate";
parameter Real Cp(unit="kJ/kg*K")=2.8"Specific heat of the plate";

//==================
//Variable section

Real h(unit="W/m^2*K")"Convective heat transfer coefficient";
Real Q(unit="W")"Rate of heat transfer of plate";

//==================
//Equation section
equation
Q=m*Cp*dt*1000;
h=Q/(A*(Tp-Ta));
end Ex1_6;
//=============================================
