//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1:Fundamental Concepts
//Example :1.7 page 10
//Topic:After sunset radiant energy

//=============================================================================
model Ex1_7
extends Modelica.Constants;

//==================
//Parameter section

parameter Real em=0.9"Emissivity value of the brick (dimensionless)";
parameter Real T(unit="degree celcius")=50"Temperature of the wall";

//==================
//Variable section

Real E(unit="W/m^2")"Emitted Radiant energy per square metre";

//===================
//Equation section
equation
E=em*sigma*((T+273.15)^4);//Considering E/A as E
end Ex1_7;
//========================================================
