//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.1 page 424
//Topic:Food processing plant
//===================================================================================

package Ex10_1

//=========================================================================

model Ex10_1_a
extends Modelica.Math;
extends Modelica.Constants;

//=================================
//parameter section

parameter Real mc(unit="kg/s")=0.18"Mass flow rate of water";
parameter Real Tw1(unit="degree celcius")=55"Entering temperature of water";
parameter Real Tw2(unit="degree celcius")=40"Exit temperature of water";
parameter Real Ts1(unit="degree celcius")=8"Entering temperature of Brine solution";
parameter Real Ts2(unit="degree celcius")=14"Exit temperature of Brine solution";
parameter Real U(unit="W/m^2K")=800"Overall heat transfer coefficient";
parameter Real Cpw(unit="kJ/kgK")=4.18"Specific heat capacity of water";

//=================================
//Variable section

Real Q(unit="W")"Rate of heat transfer";
Real dT11(unit="degree celcius")"Temperature difference";
Real dT21(unit="degree celcius")"Temperature difference";
Real LMTD1(unit="")"Log Mean Temperature Difference";
Real A1(unit="m^2")"Area of heat exchanger for parallel flow arrangement";

//=================================
//Equation section

equation

Q=mc*Cpw*(Tw1-Tw2)*1e3;
dT11=Tw1-Ts1;
dT21=Tw2-Ts2;
LMTD1=(dT21-dT11)/(log(dT21/dT11));
A1=Q/(U*LMTD1);

end Ex10_1_a;

//=========================================================================

model Ex10_1_b
extends Ex10_1_a;

//=================================
//Variable section

Real dT12(unit="degree celcius")"Temperature difference";
Real dT22(unit="degree celcius")"Temperature difference";
Real LMTD2(unit="")"Log Mean Temperature Difference";
Real A2(unit="m^2")"Area of heat exchanger for counterflow arrangement";

//=================================
//Equation section

equation

dT12=Tw1-Ts2;
dT22=Tw2-Ts1;
LMTD2=(dT22-dT12)/(log(dT22/dT12));
A2=Q/(U*LMTD2);

end Ex10_1_b;


//=========================================================================

end Ex10_1;
