//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.5 page 432
//Topic:Water heated in counter flow heat exchanger
//===================================================================================

package Ex10_5

//=========================================================================

model Ex10_5_a
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real mw(unit="kg/s")=1.2"Mass flow rate of water";
parameter Real Twi(unit="degree celcius")=30"Inlet temperature of water";
parameter Real Two(unit="degree celcius")=90"Outlet temperature of water";
parameter Real Cpw(unit="kJ/kgK")=4.18"Specific heat of water";
parameter Real mg(unit="kg/s")=2"Mass flow rate of geothermal fluid";
parameter Real Tgi(unit="degree celcius")=160"Inlet temperature of geothermal fluid";
parameter Real Cpg(unit="kJ/kgK")=4.31"Specific heat of geothermal fluid";
parameter Real d(unit="mm")=15"Diameter of the inner tube";
parameter Real U(unit="W/m^2K")=600"Overall heat transfer coefficient";

//=================================
//Variable section

Real Q(unit="kW")"Rate of heat transfer";
Real Tgo(unit="degree celcius")"Outlet temperature of geothermal fluid";
Real dT1(unit="degree celcius")"Temperature difference";
Real dT2(unit="degree celcius")"Temperature difference";
Real LMTD(unit="degree celcius")"Log mean temperature difference";
Real A1(unit="m^2")"Area of the heat exchanger by LMTD method";
Real L1(unit="m")"Length of the tube required (by LMTD method)";

//=================================
//Equation section

equation

Q=mw*Cpw*(Two-Twi);
Tgo=Tgi-(Q/(mg*Cpg));
dT1=Tgi-Two;
dT2=Tgo-Twi;
LMTD=(dT1-dT2)/(log(dT1/dT2));
A1=(Q*1e3)/(U*LMTD);
L1=A1/(pi*d*1e-3);


end Ex10_5_a;

//=========================================================================

model Ex10_5_b
extends Ex10_5_a;

//=================================
//Variable section

Real Cmin(unit="kW/K")"Heat capacity of cold fluid";
Real Cmax(unit="kW/K")"Heat capacity of hot fluid";
Real Cr(unit="")"Capacity ratio";
Real Ec(unit="")"Effectiveness factor";
Real NTU(unit="")"Number of transfer units";
Real A2(unit="m^2")"Area of the heat exchanger by NTU method";
Real L2(unit="m")"Length of the tube required (by NTU method)";

//=================================
//Equation section

equation

Cmin=mw*Cpw;
Cmax=mg*Cpg;
Cr=Cmin/Cmax;
Ec=Q/(Cmin*(Tgi-Twi));
exp(NTU/(1/(Cr-1)))=(Ec-1)/((Ec*Cr)-1);
A2=(NTU*Cmin*1e3)/U;
L2=A2/(pi*d*1e-3);

end Ex10_5_b;



//=========================================================================

end Ex10_5;
