//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 11:Radiation heat transfer
//Example :11.8 page 479
//Topic:Concentric spheres seperated
//===================================================================================

package Ex11_8

//=========================================================================

model Ex11_8_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real D1(unit="m")=0.5"Diameter of inner sphere";
parameter Real D2(unit="m")=1"Diameter of outer sphere";
parameter Real T1(unit="K")=400"Temperature of inner sphere";
parameter Real T2(unit="K")=300"Temperature of outer sphere";
parameter Real E1(unit="")=0.5"Emissivity of surface 1";
parameter Real E21(unit="")=0.5"Emissivity of surface 2";
parameter Real E22(unit="")=1"Emissivity of surface 2";

//=================================
//Variable section

Real Q1(unit="W")"Rate of heat transfer when spheres are black";

//=================================
//Equation section

equation

Q1=pi*(D1^2)*sigma*((T1^4)-(T2^4));

end Ex11_8_a;

//=========================================================================

model Ex11_8_b_i
extends Ex11_8_a;

//=================================
//Variable section

Real Q2(unit="W")"Rate of heat transfer when both are gray bodies";

//=================================
//Equation section

equation

Q2=(pi*(D1^2)*sigma*((T1^4)-(T2^4)))/((1/E1)+(((D1/D2)^2)*((1/E21)-1)));

end Ex11_8_b_i;
//=========================================================================

model Ex11_8_b_ii
extends Ex11_8_a;
extends Ex11_8_b_i;

//=================================
//Variable section

Real Q3(unit="W")"Rate of heat transfer when outer sphere is black body";
Real Err(unit="percent")"Induced Error";

//=================================
//Equation section

equation

Q3=(pi*(D1^2)*sigma*((T1^4)-(T2^4)))/((1/E1)+(((D1/D2)^2)*((1/E22)-1)));
Err=((Q3-Q2)/Q2)*100;

end Ex11_8_b_ii;

//=========================================================================

end Ex11_8;

//==============================================================================
//Remarks
//Area is miscalculated as (pi/4*D1^2).Actual area is (Pi*D1^2).
//Only substitution is wrong,but final answer is correct.
