//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 12:Principles of mass transfer
//Example :12.2 page 515
//Topic:Wet bulb thermometer
//===================================================================================

model Ex12_2

//=================================
//parameter section

parameter Real Tw(unit="degree celcius")=20"Wet-bulb temperature";
parameter Real To(unit="degree celcius")=40"Atmospheric temperature";
parameter Real Dab(unit="m^2/s")=0.26e-4"Diffusion coefficient";
parameter Real hfg(unit="kJ/kg")=2407"Enthalpy of vapourisation of water";
parameter Real Ps(unit="kPa")=2.34"Saturation presssure ";//Found from steam table at Tw
parameter Real M(unit="kg/kmol")=18"Molecular wieght of water";
//Properties of air at film temperature
parameter Real rho(unit="kg/m^3")=1.13"Density of air";
parameter Real Cp(unit="kJ/kgK")=1.007"Specific heat of air";
parameter Real a(unit="m^2/s")=0.241e-4"Thermal difussivity of air";
parameter Real rhos(unit="kg/m^3")=0.051"Density of saturated water vapour at To";

//=================================
//Variable section

Real rhob(unit="kg/m^3")"Density of water at bulb surface";
Real rhoo(unit="kg/m^3")"Density of water vapour at free steam ";
Real Rh(unit="percent")"Relative humidity in free steam air";

//=================================
//Equation section

equation

rhob=((Ps*1e3)*M)/((8.314*1e3)*(Tw+273));
rhoo=rhob-((rho*Cp*((a/Dab)^(2/3)))*((To-Tw)/hfg));
Rh=(rhoo/rhos)*100;

end Ex12_2;
